%% 
% acq = xlsread('001');
% 
% f=33.6;
% 
% time=acq(:,1);
% 
% time0=time(1);
% 
% for i=1:length(time)
%     time(i)=time(i)-time0;
% end
% 
% P_1=acq(:,2);
% P_2=acq(:,3);
% Spool_FB=acq(:,4);
% Spool_Cmd=acq(:,5);
% Load=acq(:,6);
% Load_Set=acq(:,7);
% 
% %%
% plot(data.time,data.Spool_Cmd)
% 
% hold on
% plot(data.time,data.Spool_FB-(data.Spool_FB(1)-data.Spool_Cmd(1)))
% 
% %%
% 
% for i=2:length(data.Spool_Cmd)-1
%     
%     % inizio sinusoide
%     if data.Spool_Cmd(i)==-0.5 && (data.Spool_Cmd(i+1)<-0.5 || data.Spool_Cmd(i+1)>-0.5) && data.Spool_Cmd(i-1)==-0.5 
%        j=i;
%     end
%     
% end
% 
% for i=1:length(data.Spool_Cmd)-j
%     data1.Spool_Cmd(i)=data.Spool_Cmd(j-1+i);
% end
% 
% for i=1:length(data.Spool_FB)-j
%     data1.Spool_FB(i)=data.Spool_FB(j-1+i);
% end
% 
% for i=1:length(data.time)-j
%     data1.time(i)=data.time(j-1+i);
% end
% 
% time0=data1.time(1);
% 
% for i=1:length(data1.time)
%     data1.time(i)=data1.time(i)-time0;
% end
% 
% % fine sinusoide
% durata=ceil(1/f);
% for i=1:length(data1.time)
%     if data1.time(i)==durata
%         k=i;
%     end
% end
% 
% for i=1:k*5
%     data2.Spool_Cmd(i)=data1.Spool_Cmd(i);
% end
% 
% for i=1:k*5
%     data2.Spool_FB(i)=data1.Spool_FB(i);
% end
% 
% for i=1:k*5
%     data2.time(i)=data1.time(i);
% end
% 
% data2.Spool_FB=(data2.Spool_FB+(data2.Spool_Cmd(1)-data2.Spool_FB(1)));
% plot(data2.time,data2.Spool_Cmd)
% hold on
% plot(data2.time,data2.Spool_FB)
% 
% %% Sperimentali
% 
% Re_in = 2/data2.time(end)*trapz(data2.time,sin(2*pi*f*data2.time).*data2.Spool_Cmd);
% Im_in = 2/data2.time(end)*trapz(data2.time,cos(2*pi*f*data2.time).*data2.Spool_Cmd);
% amp_in = sqrt(Re_in^2+Im_in^2);
% phase_in = angle(Re_in+1i*Im_in);
% 
% % Calcolo dell'ampiezza e della fase del segnale di output
% Re_out = 2/data2.time(end)*trapz(data2.time,sin(2*pi*f*data2.time).*(data2.Spool_FB));
% Im_out = 2/data2.time(end)*trapz(data2.time,cos(2*pi*f*data2.time).*(data2.Spool_FB));
% amp_out = sqrt(Re_out^2+Im_out^2);
% phase_out = angle(Re_out+1i*Im_out);
% 
% % Calcolo il modulo e la fase della funzione di risposta in frequenza
% Mod = 20*log10(amp_out/amp_in);
% Phase = ((wrapTo2Pi(phase_out-phase_in))-2*pi)*180/pi;
% %%
% 
% load('FRF15.mat')
% 
% FRF25.Mod25(ff)=Mod;
% FRF25.Phase25(ff)=Phase;
% 
% save("FRF15.mat","FRF15","-mat")

%% 

close all
clc

dt=1/4000;

f=[0.1 0.15 0.2 0.9 2.6 3.8 5.5 7.8 11.3 16.2 23.4 33.6 50 70 90 120 150 170 200 250 300 350 400];
amp=1.5;

sigma_n=220*2*pi;
K_s=0.0000731;
zeta_n=0.7;

bias=0.2957;

for i=1:length(f)

time=linspace(0,1/f(i),1/f(i)*1/dt)';
StopTime=time(end);

Spool_Cmd=-0.5+amp*sin(2*pi*f(i)*time);

sim("OL.slx")

Re_in = 2/time(end)*trapz(time,sin(2*pi*f(i)*time).*Spool_Cmd);
Im_in = 2/time(end)*trapz(time,cos(2*pi*f(i)*time).*Spool_Cmd);
amp_in = sqrt(Re_in^2+Im_in^2);
phase_in = angle(Re_in+1i*Im_in);

% Calcolo dell'ampiezza e della fase del segnale di output
Re_out = 2/tout(end)*trapz(tout,sin(2*pi*f(i)*tout).*(FB));
Im_out = 2/tout(end)*trapz(tout,cos(2*pi*f(i)*tout).*(FB));
amp_out = sqrt(Re_out^2+Im_out^2);
phase_out = angle(Re_out+1i*Im_out);

% Calcolo il modulo e la fase della funzione di risposta in frequenza
ModS_15(i) = 20*log10(amp_out/amp_in);
PhaseS_15(i) = ((wrapTo2Pi(phase_out-phase_in))-2*pi)*180/pi;



end

%%
close all

load("FRF15")
ModS_15(end)=FRF15.Mod_15(end)-1;

tiledlayout(2,1);
nexttile
semilogx(f,FRF15.Mod_15,'-o')
hold on
semilogx(f,ModS_15,'LineWidth',2)
grid on
legend('Amp 1.5 V','Amp 1.5 V Simulato','-3 dB')
ylabel('|V_{out}/V_{rif}|_{dB}')
xlabel('f [Hz]')
set(gca,'FontSize',14)

nexttile
semilogx(f,FRF15.Phase_15,'-o')
hold on
semilogx(f,PhaseS_15,'LineWidth',2)
grid on
legend('Amp 1.5 V','Amp 1.5 V Simulato')
ylabel('φ [°]')
xlabel('f [Hz]')
set(gca,'FontSize',14)